//------------------------------------------------------------------------------
// Lab.10: Design dead beat controller for a given system.
//              scilab - 5.5.1
//              Operating System : Windows 7, 32-bit
//*****************************************************************************
//Clean the environment
close;
clear;
clc;

//Sampling time
Ts=0.5;

// State space representation of the continuous time system
A=[0 1;0 0];
B=[0 1]';
C=[1 0];
D=0;

sys1=syslin('c',A,B,C,D)

//Discrete model of the system

sys=dscr(sys1,Ts)
mprintf('Discrete model of the system is sys=')
disp(sys)

// Desired poles
Pd=[0 0];

// State feedback gain matrix
K=ppol(sys.A,sys.B,Pd)
mprintf('State feedback gain matrix is K=')
disp(K)

//Responses
t=0:Ts:10;
u=ones(1,length(t));

//Response of open loop system
y1=flts(u,sys);
plot2d2(t,y1,2)
xgrid(35)
title('Response of the open loop system','fontsize',3)
xlabel('kt','fontsize',2)
ylabel('y(k)','fontsize',2)


//Response of closed loop system
syscl=syslin('d',sys.A-sys.B*K,sys.B,sys.C,0)
y=flts(u,syscl);
figure,
plot2d2(t,y,2)
f=get("current_figure") //Current figure handle                
f.background=8
xgrid(36)
title('Response of the closed loop system with dead beat controller','fontsize',3)
xlabel('kt','fontsize',2)
ylabel('y(k)','fontsize',2)
